<?php
	
define ('TEMPLATE_DOMAIN','freshy');
load_theme_textdomain(TEMPLATE_DOMAIN);

if ( function_exists('register_sidebar') ) {
	
	$freshy_options = get_option('freshy_options');
	if ($freshy_options['sidebar_left'] && $freshy_options['sidebar_right']) $sidebars = 2;
	else $sidebars = 1;
	
    register_sidebars($sidebars, array(
    'before_widget' => '<div id="%1$s" class="widget %2$s">',
    'after_widget' => '</div>',
        'before_title' => '<h2 class="title">',
        'after_title' => '</h2>',
    ));

}

add_action('widgets_init', 'freshy_widgets_init');

add_filter("mce_buttons", "freshy_editor_mce_buttons", 0);
add_action("mce_options", "freshy_editor_mce_options", 0);

if (!class_exists('Nice_theme')) add_action('wp_head','freshy_head');

function freshy_editor_mce_options() {
	print 'content_css:"';bloginfo('stylesheet_directory');print '/content.css",';
}

function freshy_editor_mce_buttons($buttons) {
	array_pop($buttons);
	$buttons[] = "styleselect";
	$buttons[] = "wp_adv_end";
	//var_dump($buttons);
	return $buttons;
}

function freshy_wp_list_pages($args = '') {
	$defaults = array(
		'depth' => 0, 'show_date' => '',
		'date_format' => get_option('date_format'),
		'child_of' => 0, 'exclude' => '',
		'title_li' => __('Pages'), 'echo' => 1,
		'authors' => '', 'sort_column' => 'menu_order, post_title'
	);

	$r = wp_parse_args( $args, $defaults );
	extract( $r, EXTR_SKIP );

	$output = '';
	$current_page = 0;

	// sanitize, mostly to keep spaces out
	$r['exclude'] = preg_replace('[^0-9,]', '', $r['exclude']);

	// Allow plugins to filter an array of excluded pages
	$r['exclude'] = implode(',', apply_filters('wp_list_pages_excludes', explode(',', $r['exclude'])));

	// Query pages.
	$pages = get_pages($r);

	if ( !empty($pages) ) {
		if ( $r['title_li'] )
			$output .= '<li class="pagenav">' . $r['title_li'] . '<ul>';

		global $wp_query;
		if ( is_page() )
			$current_page = $wp_query->get_queried_object_id();
		$output .= freshy_walk_page_tree($pages, $r['depth'], $current_page, $r);

		if ( $r['title_li'] )
			$output .= '</ul></li>';
	}

	$output = apply_filters('wp_list_pages', $output);

	if ( $r['echo'] )
		echo $output;
	else
		return $output;
}

function freshy_walk_page_tree() {
	$walker = new freshy_Walker_Page;
	$args = func_get_args();
	return call_user_func_array(array(&$walker, 'walk'), $args);
}

class freshy_Walker_Page extends Walker {
	var $tree_type = 'page';
	var $db_fields = array ('parent' => 'post_parent', 'id' => 'ID'); //TODO: decouple this

	function start_lvl($output, $depth) {
		$indent = str_repeat("\t", $depth);
		$output .= "\n$indent<ul>\n";
		return $output;
	}

	function end_lvl($output, $depth) {
		$indent = str_repeat("\t", $depth);
		$output .= "$indent</ul>\n";
		return $output;
	}

	function start_el($output, $page, $depth, $current_page, $args) {
		global $post;
		if ( $depth )
			$indent = str_repeat("\t", $depth);
		extract($args, EXTR_SKIP);
		$css_class = 'page_item page-item-'.$page->ID;
		$_current_page = get_page( $current_page );
		if ( $page->ID == $current_page )
			$css_class .= ' current_page_item ';
		elseif ( $_current_page && $page->ID == $_current_page->post_parent )
			$css_class .= ' current_page_parent';
		elseif ( $page->ID == freshy_get_page_root($_current_page->post_parent) )
			$css_class .= ' current_page_parent';
		elseif ( get_option('page_for_posts') == $page->ID && $_GET['page_id'] == $page->ID ) // a little hacky
			$css_class .= ' current_page_parent';
		elseif ( get_option('page_for_posts') == $page->ID && $post->post_type == 'post' ) // a little hacky
			$css_class .= ' current_page_parent';

		$output .= $indent . '<li class="' . $css_class . '"><a href="' . get_page_link($page->ID) . '" title="' . attribute_escape(apply_filters('the_title', $page->post_title)) . '">' . apply_filters('the_title', $page->post_title) . '</a>';

		if ( !empty($show_date) ) {
			if ( 'modified' == $show_date )
				$time = $page->post_modified;
			else
				$time = $page->post_date;

			$output .= " " . mysql2date($date_format, $time);
		}

		return $output;
	}

	function end_el($output, $page, $depth) {
		$output .= "</li>\n";

		return $output;
	}

}
/*
function freshy_get_page_root($id)
{
	$parent = &get_post($id);
	if ( $parent->post_parent && ($parent->post_parent != $parent->ID) )
		$parent = freshy_get_page_root($parent->post_parent);
	return $parent;
}*/

function freshy_widgets_init()
{
	register_sidebar_widget('Categories OR Pages', 'freshy_menu');
	register_widget_control('Categories OR Pages', 'freshy_menu_control', 300, 90);
}

function freshy_head()
{
	if (get_option('nt_file'))
	{
		print '<link rel="stylesheet" href="'.get_bloginfo('stylesheet_directory').'/'.get_option('nt_file').'" type="text/css" media="screen"/>';
	}
}

function freshy_menu_control() {
	$options = $newoptions = get_option('widget_categories');
	if ( $_POST['categories-submit'] ) {
		$newoptions['title'] = strip_tags(stripslashes($_POST['categories-title']));
	}
	if ( $options != $newoptions ) {
		$options = $newoptions;
		update_option('widget_categories', $options);
	}
	$title = wp_specialchars($options['title']);
?>
			<p><label for="categories-title"><?php _e('Title:'); ?> <input style="width: 250px;" id="categories-title" name="categories-title" type="text" value="<?php print $title; ?>" /></label></p>
			<input type="hidden" id="categories-submit" name="categories-submit" value="1" />
<?php
}

function freshy_widget_links($args) {
	global $wpdb;
	$title = empty($options['title']) ? __('Links') : $options['title'];
	?>
	<h2><?php print $before_widget.$before_title.$title.$after_title; ; ?></h2>
	<ul>
	<?php freshy_links_menu(); ?>
	</ul>
	<?php
}

function freshy_links_menu() {
	global $wpdb;
	$ver = substr(get_bloginfo('version'), 0, 3);
	if (floatval($ver) <= 2)
	{
		$link_cats = $wpdb->get_results("SELECT cat_id, cat_name FROM $wpdb->linkcategories");
		foreach ($link_cats as $link_cat)
		{ ?>
			<li id="linkcat-<?php print $link_cat->cat_id; ?>"><?php print $link_cat->cat_name; ?>
			<ul>
			<?php wp_get_links($link_cat->cat_id); ?>
			</ul>
			</li>
		<?php
		}
	}
	else {
		$link_cats = $wpdb->get_results("SELECT DISTINCT cat_name, category_id FROM $wpdb->categories INNER JOIN $wpdb->link2cat ON $wpdb->categories.cat_id=$wpdb->link2cat.category_id");
		foreach ($link_cats as $link_cat)
		{ ?>
			<li id="linkcat-<?php print $link_cat->cat_id; ?>"><?php print $link_cat->cat_name; ?>
			<ul>
			<?php wp_get_links('category='.$link_cat->category_id.'&before=<li>&after=</li>&show_description=0&limit=100'); ?>
			</ul>
			</li>
			<?php
		}
	}	
}

// backward compatibility for yammyamm
function freshy_yy_menu() {
	if(function_exists('yy_menu')) : ?>
		<li class="<?php if (yy_is_home()) { ?>current_page_item<?php } else { ?>page_item<?php } ?>">
			<a class="first_menu" href="<?php print get_settings('home'); ?>/">
				<?php _e('Home',TEMPLATE_DOMAIN); ?>
			</a>
		</li>
		<li class="<?php if (((is_home()) && !(is_paged())) or (is_archive()) or (is_single()) or (is_paged()) or (is_search())) { ?>current_page_item<?php } else { ?>page_item<?php } ?>">
			<a href="<?php print yy_home_url('blog'); ?>">
				<?php _e('Blog',TEMPLATE_DOMAIN); ?>
			</a>
		</li>

		<?php yy_menu('sort_column=menu_order&depth=1&title_li=','none'); ?>
	<?php return true; endif; 
	return false;
}

function freshy_menu($args_pages='', $args_cats='') {
	
	global $post, $wpdb, $cat, $ID, $notfound, $freshy_options;
	
	$options = get_option('widget_categories');

	$c = 0;
	$h = 0;
	if ($freshy_options['menu_rss'] == 1) $rss = '&feed_image='.get_bloginfo('stylesheet_directory').'/images/icons/feed-icon-10x10.gif';
	$title = empty($options['title']) ? __('Navigation') : $options['title'];
	
	if ($freshy_options['menu_type']=='auto') {

		// page menu
		if (($post->post_status=='static' || is_page()) && $notfound!='1' && $args_pages!='none') {
			?>
			<h2><?php print $title; ?></h2>
			<ul>
			<?php
	        wp_list_pages($args_pages.'&title_li=');
	        ?>
	        </ul>
	        <?php
		}
		// cats & posts menu
		else if (!is_page() && $notfound!='1' && $args_cats!='none') {
			?>
			<h2><?php print $title; ?></h2>
			<ul>
			<?php
	        wp_list_cats($args_cats.'&hierarchical=$h'.$rss);
	        ?>
	        </ul>
	        <?php
		}
		// bad things happened but dispay something anyway
		else {
			?>
				<h2><?php _e('Categories',TEMPLATE_DOMAIN); ?></h2>
				<ul>
				<?php wp_list_cats($args_cats.'&hierarchical=$h'.$rss); ?>
				</ul>
			<?php
		}
	}
	else {
		?>
			<h2><?php _e('Pages',TEMPLATE_DOMAIN); ?></h2>
			<ul>
			<?php wp_list_pages('sort_column=menu_order&title_li='); ?>
			</ul>
			<h2><?php _e('Categories',TEMPLATE_DOMAIN); ?></h2>
			<ul>
			<?php wp_list_cats($args_cats.'&optioncount=$c&hierarchical=$h'.$rss); ?>
			</ul>
		<?php
	}
}

//add_filter('wp_list_pages','freshy_wp_list_pages');
//breaks menu markup... too bad
/*
function freshy_wp_list_pages($output)
{
	global $post, $wp_query;
	$top_parent = freshy_get_page_root($wp_query->query_vars['page_id']);
	$output = preg_replace('%(class=")([^>]+)("><a href="'.str_replace('?', '\?', get_permalink($top_parent)).')"%is','\\1current_page_parent \\2\\3',$output);
	return $output;
}*/

function freshy_get_page_root($id,$level=0)
{
	$parents = array();
	$curpost = get_post($id);
	array_push($parents,$id);
	while ($curpost->post_parent != 0) {
		array_push($parents,$curpost->post_parent);
		$curpost = get_post($curpost->post_parent);
	}
	$parents = array_reverse($parents);
	if (class_exists('YammYamm')) $level = $level+1;
	return $parents[$level];
}

function freshy_layout_class() {
	global $freshy_options, $post;
	$freshy_options = get_option('freshy_options');
	$return ='';

	$ids_right = explode(',',$freshy_options['hide_sidebar_posts']);
	$ids_left = explode(',',$freshy_options['hide_sidebar_left_posts']);
	
	if ($freshy_options['sidebar_left'] == 1 && in_array($post->ID, $ids_left) === FALSE) $return .= 'sidebar_left';
	if ($freshy_options['sidebar_right'] == 1 && in_array($post->ID, $ids_right) === FALSE) $return .= ' sidebar_right';
	
	return 'class="'.$return.'"';
}

// SET OPTIONS

$freshy_options=array();
$freshy_default_options=array();

freshy_set_options();

function freshy_set_options() {
	
	global $freshy_options;
	
	$freshy_default_options['first_menu_label']='Home';
	$freshy_default_options['blog_menu_label']='Blog';
	$freshy_default_options['last_menu_label']='Contact';
	$freshy_default_options['last_menu_type']='';
	$freshy_default_options['contact_email']='';
	$freshy_default_options['contact_link']='';
	$freshy_default_options['sidebar_left']=0;
	$freshy_default_options['sidebar_right']=1;
	$freshy_default_options['gravatar_size']=50;
	
	$freshy_default_options['menu_type']='auto';
	$freshy_default_options['args_pages']='sort_column=menu_order&title_li=';
	$freshy_default_options['args_cats']='hide_empty=0&sort_column=name&optioncount=0&title_li=&hierarchical=1';
	$freshy_default_options['menu_rss']=0;
	$freshy_default_options['date']=1;
	$freshy_default_options['time']=0;
	$freshy_default_options['comment_date']=1;
	$freshy_default_options['comment_time']=0;
	$freshy_default_options['author']=1;
	$freshy_default_options['header_search']=0;
	$freshy_default_options['hide_sidebar_posts']='';
	$freshy_default_options['hide_sidebar_left_posts']='';
	
	$existing_options = get_option('freshy_options'); 
	if (is_array($existing_options)) {
		foreach ($existing_options as $key=>$val) { 
			$freshy_options[$key]=$val;
		}
		foreach ($freshy_default_options as $key=>$val) { 
			if (!$freshy_options[$key]) $freshy_options[$key]=$val;
		}
	}
	else {
		$freshy_options=$freshy_default_options;
		update_option('freshy_options', $freshy_options);
	}
}

// ADMIN

add_action('admin_menu', 'freshy_add_theme_page');

function freshy_add_theme_page() {
	add_theme_page('Freshy Theme Options', 'Freshy Theme Options', 'edit_themes', basename(__FILE__), 'freshy_theme_page');
}

function freshy_theme_page() {
	
	global $freshy_options;
	$freshy_options = get_option('freshy_options');
	
	if ( $_GET['page'] == basename(__FILE__) ) {
		
		if (isset($_POST['freshy_options_update'])) {
			
		  $freshy_updated_options = array();
			$freshy_updated_options = $_POST;
			
			update_option('nt_file',$freshy_updated_options['theme']);
			
			// menus
			$freshy_updated_options['custom_menus'] = $freshy_options['custom_menus'];
			
			if ($freshy_updated_options['new_custom_menu_label']!='') {
				if (!is_array($freshy_updated_options['custom_menus'])) $freshy_updated_options['custom_menus'] = array();
				$tmp = array();
				$tmp['label'] = $freshy_updated_options['new_custom_menu_label'];
				$tmp['url'] = $freshy_updated_options['new_custom_menu_url'];
				array_push($freshy_updated_options['custom_menus'],$tmp);
			}
			$i=0;
			if (is_array($freshy_updated_options['custom_menus'])) {
				foreach ($freshy_updated_options['custom_menus'] as $custom_menu) {
					if ($freshy_updated_options['custom_menu_'.$i] == true) unset($freshy_updated_options['custom_menus'][$i]);
					$i++;
				} 
			}
			
			// quick links
			$freshy_updated_options['custom_quicklinks'] = $freshy_options['custom_quicklinks'];
			
			if ($freshy_updated_options['new_custom_quicklink_label']!='') {
				if (!is_array($freshy_updated_options['custom_quicklinks'])) $freshy_updated_options['custom_quicklinks'] = array();
				$tmp = array();
				$tmp['label'] = $freshy_updated_options['new_custom_quicklink_label'];
				$tmp['url'] = $freshy_updated_options['new_custom_quicklink_url'];
				array_push($freshy_updated_options['custom_quicklinks'],$tmp);
			}
			$i=0;
			if (is_array($freshy_updated_options['custom_quicklinks'])) {
				foreach ($freshy_updated_options['custom_quicklinks'] as $custom_quicklink) {
					if ($freshy_updated_options['custom_quicklink_'.$i] == true) unset($freshy_updated_options['custom_quicklinks'][$i]);
					$i++;
				} 
			}
			update_option('freshy_options', $freshy_updated_options);
			
			$freshy_options = get_option('freshy_options');
			print '<div class="updated"><p>' . __('Freshy options updated.',TEMPLATE_DOMAIN) . '</p></div>';
		}

		print '<div class="wrap">
		<h2>'.__('Freshy Options',TEMPLATE_DOMAIN).'</h2>
		
		<form name="freshy_options_form" method="post">
		<input type="hidden" name="freshy_options_update" value="update" />
		
		<table class="form-table">';
		
		//if (isset(get_option('nt_file'))) {
			?>
				<tr>
					<th scope="row">
						<label for="theme"><?php _e('Choose a custom style :','customize') ?></label>
					</th>
					<td>
						<select id="theme" name="theme">
							<?php
							
							$theme_info = current_theme_info();
							$path = WP_CONTENT_DIR.$theme_info->template_dir.'/';
							$themes = freshy_list_files($path,'custom_',array('custom_template.css'));
							
							print '<option value="custom_template.css"';
							if (get_option('nt_file') == "custom_template.css") print ' selected="selected"';
							print '>'.__('Default style','customize').'</option>';
							foreach ($themes as $theme)
							{
								print '<option value="'.$theme.'"';
								if (get_option('nt_file') == $theme) print ' selected="selected"';
								print '>'.$theme.'</option>';
							}
							?>
						</select>
					</td>
				</tr>
			<?php
		//}
		print '<tr><td colspan="2"><h3>'.__('Layout :',TEMPLATE_DOMAIN).'</h3></td></tr>
			<tr>
				<th style="width:50%" scope="row">
					<label>'.__('Display left sidebar',TEMPLATE_DOMAIN).'</label>
				</th>
				<td>					
					<label for="sidebar_left_yes"><input name="sidebar_left" id="sidebar_left_yes" type="radio" value="1" ';
					if ($freshy_options['sidebar_left'] == 1) {print 'checked="checked" ';}
					print '/> '.__('Yes',TEMPLATE_DOMAIN).'</label>
					<br/>
					<label for="sidebar_left_no"><input name="sidebar_left" id="sidebar_left_no" type="radio" value="0" ';
					if ($freshy_options['sidebar_left'] == 0) {print 'checked="checked" ';}
					print '/> '.__('No',TEMPLATE_DOMAIN).'</label>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label>'.__('Hide left sidebar on these posts',TEMPLATE_DOMAIN).'</label>
					<br/>
					<small>'.__('Enter posts ids separated by commas',TEMPLATE_DOMAIN).'</small>
				</th>
				<td>
					<textarea name="hide_sidebar_left_posts">'.$freshy_options['hide_sidebar_left_posts'].'</textarea>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label>'.__('Display right sidebar',TEMPLATE_DOMAIN).'</label>
				</th>
				<td>					
					<label for="sidebar_right_yes"><input name="sidebar_right" id="sidebar_right_yes" type="radio" value="1" ';
					if ($freshy_options['sidebar_right'] == 1) {print 'checked="checked" ';}
					print '/> '.__('Yes',TEMPLATE_DOMAIN).'</label>
					<br/>
					<label for="sidebar_right_no"><input name="sidebar_right" id="sidebar_right_no" type="radio" value="0" ';
					if ($freshy_options['sidebar_right'] == 0) {print 'checked="checked" ';}
					print '/> '.__('No',TEMPLATE_DOMAIN).'</label>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label>'.__('Hide right sidebar on these posts',TEMPLATE_DOMAIN).'</label>
					<br/>
					<small>'.__('Enter posts ids separated by commas',TEMPLATE_DOMAIN).'</small>
				</th>
				<td>
					<textarea name="hide_sidebar_posts">'.$freshy_options['hide_sidebar_posts'].'</textarea>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label>'.__('Navigation menu behaviour',TEMPLATE_DOMAIN).'</label>
				</th>
				<td>					
					<label for="menu_type_auto"><input name="menu_type" id="menu_type_auto" type="radio" value="auto" ';
					if ($freshy_options['menu_type'] == 'auto') {print 'checked="checked" ';}
					print '/> '.__('Auto : Display subpages on pages and blog categories in blog',TEMPLATE_DOMAIN).'</label>
					<br/>
					<label for="menu_type_normal"><input name="menu_type" id="menu_type_normal" type="radio" value="normal" ';
					if ($freshy_options['menu_type'] == 'normal') {print 'checked="checked" ';}
					print '/> '.__('Normal : Always display categories and pages',TEMPLATE_DOMAIN).'</label>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label>'.__('Navigation menu rss',TEMPLATE_DOMAIN).'</label>
				</th>
				<td>					
					<label for="menu_rss_true"><input name="menu_rss" id="menu_rss_true" type="radio" value="1" ';
					if ($freshy_options['menu_rss'] == 1) {print 'checked="checked" ';}
					print '/> '.__('Display rss icon with categories',TEMPLATE_DOMAIN).'</label>
					<br/>
					<label for="menu_rss_false"><input name="menu_rss" id="menu_rss_false" type="radio" value="0" ';
					if ($freshy_options['menu_rss'] == 0) {print 'checked="checked" ';}
					print '/> '.__('Do not display rss icon with categories',TEMPLATE_DOMAIN).'</label>
				</td>
			</tr>
			<tr><td colspan="2"><h3>'.__('Date options :',TEMPLATE_DOMAIN).'</h3>
				<small>'.__('You can change date formatting under',TEMPLATE_DOMAIN).' <a href="options-general.php">Admin &gt; Options &gt; General</a></small>		
			</td></tr>
			<tr>
				<th scope="row">
					<label>'.__('Show date on posts',TEMPLATE_DOMAIN).' </label>
				</th>
				<td>					
					<label for="date_yes"><input name="date" id="date_yes" type="radio" value="1" ';
					if ($freshy_options['date'] == 1) {print 'checked="checked" ';}
					print '/> '.__('Yes',TEMPLATE_DOMAIN).'</label>
					<br/>
					<label for="date_no"><input name="date" id="date_no" type="radio" value="0" ';
					if ($freshy_options['date'] == 0) {print 'checked="checked" ';}
					print '/> '.__('No',TEMPLATE_DOMAIN).'</label>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label>'.__('Show time on posts',TEMPLATE_DOMAIN).' </label>
				</th>
				<td>					
					<label for="time_yes"><input name="time" id="time_yes" type="radio" value="1" ';
					if ($freshy_options['time'] == 1) {print 'checked="checked" ';}
					print '/> '.__('Yes',TEMPLATE_DOMAIN).'</label>
					<br/>
					<label for="time_no"><input name="time" id="time_no" type="radio" value="0" ';
					if ($freshy_options['time'] == 0) {print 'checked="checked" ';}
					print '/> '.__('No',TEMPLATE_DOMAIN).'</label>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label>'.__('Show date on comments',TEMPLATE_DOMAIN).' </label>
				</th>
				<td>					
					<label for="comment_date_yes"><input name="comment_date" id="comment_date_yes" type="radio" value="1" ';
					if ($freshy_options['comment_date'] == 1) {print 'checked="checked" ';}
					print '/> '.__('Yes',TEMPLATE_DOMAIN).'</label>
					<br/>
					<label for="comment_date_no"><input name="comment_date" id="comment_date_no" type="radio" value="0" ';
					if ($freshy_options['comment_date'] == 0) {print 'checked="checked" ';}
					print '/> '.__('No',TEMPLATE_DOMAIN).'</label>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label>'.__('Show time on comments',TEMPLATE_DOMAIN).' </label>
				</th>
				<td>					
					<label for="comment_time_yes"><input name="comment_time" id="comment_time_yes" type="radio" value="1" ';
					if ($freshy_options['comment_time'] == 1) {print 'checked="checked" ';}
					print '/> '.__('Yes',TEMPLATE_DOMAIN).'</label>
					<br/>
					<label for="comment_time_no"><input name="comment_time" id="comment_time_no" type="radio" value="0" ';
					if ($freshy_options['comment_time'] == 0) {print 'checked="checked" ';}
					print '/> '.__('No',TEMPLATE_DOMAIN).'</label>
				</td>
			</tr>
			<tr><td colspan="2"><h3>'.__('Other options :',TEMPLATE_DOMAIN).'</h3></td></tr>
			<tr>
				<th scope="row">
					<label>'.__('Show author on posts',TEMPLATE_DOMAIN).' </label>
				</th>
				<td>					
					<label for="author_yes"><input name="author" id="author_yes" type="radio" value="1" ';
					if ($freshy_options['author'] == 1) {print 'checked="checked" ';}
					print '/> '.__('Yes',TEMPLATE_DOMAIN).'</label>
					<br/>
					<label for="author_no"><input name="author" id="author_no" type="radio" value="0" ';
					if ($freshy_options['author'] == 0) {print 'checked="checked" ';}
					print '/> '.__('No',TEMPLATE_DOMAIN).'</label>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label>'.__('Show search in header',TEMPLATE_DOMAIN).' </label>
				</th>
				<td>					
					<label for="header_search_yes"><input name="header_search" id="header_search_yes" type="radio" value="1" ';
					if ($freshy_options['header_search'] == 1) {print 'checked="checked" ';}
					print '/> '.__('Yes',TEMPLATE_DOMAIN).'</label>
					<br/>
					<label for="header_search_no"><input name="header_search" id="header_search_no" type="radio" value="0" ';
					if ($freshy_options['header_search'] == 0) {print 'checked="checked" ';}
					print '/> '.__('No',TEMPLATE_DOMAIN).'</label>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label>'.__('Gravatar size (you must have',TEMPLATE_DOMAIN).' <a href="http://www.gravatar.com/implement.php#section_2_2">gravatar</a> '.__('plugin installed)',TEMPLATE_DOMAIN).' </label>
				</th>
				<td>
					<input name="gravatar_size" type="text" value="'.$freshy_options['gravatar_size'].'"/>
				</td>
			</tr>
			<tr><td colspan="2"><h3>'.__('Menu :',TEMPLATE_DOMAIN).'</h3></td></tr>
			<tr>
				<th scope="row">
					<label>'.__('Enter the label of the Homepage menu link',TEMPLATE_DOMAIN).' </label>
					<br/>
					<small>'.__('Modifying these labels should break internationalisation',TEMPLATE_DOMAIN).'</small>
				</th>
				<td>
					<input name="first_menu_label" type="text" value="'.$freshy_options['first_menu_label'].'"/>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label>'.__('Enter the label of the last menu link',TEMPLATE_DOMAIN).' </label>
				</th>
				<td>
					<input name="last_menu_label" type="text" value="'.$freshy_options['last_menu_label'].'"/>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label>'.__('The last menu link should be...',TEMPLATE_DOMAIN).'</label>
				</th>
				<td>					
					<label for="last_menu_type_email"><input name="last_menu_type" id="last_menu_type_email" type="radio" value="email" ';
					if ($freshy_options['last_menu_type'] == 'email') {print 'checked="checked" ';}
					print '/> '.__('A contact button to this email',TEMPLATE_DOMAIN).' :</label>
					<input name="contact_email" type="text" value="'.$freshy_options['contact_email'].'"/>

					<br/>
					
					<label for="last_menu_type_link"><input name="last_menu_type" id="last_menu_type_link" type="radio" value="link" ';
					if ($freshy_options['last_menu_type'] == 'link') {print 'checked="checked" ';}
					print '/> '.__('A custom link with this url',TEMPLATE_DOMAIN).' :</label>
					<input name="contact_link" type="text" value="'.$freshy_options['contact_link'].'"/>
						
					<br/>
												
					<label for="last_menu_type_none"><input name="last_menu_type" id="last_menu_type_none" type="radio" value="" ';
					if ($freshy_options['last_menu_type'] == '') {print 'checked="checked" ';}
					print '/> '.__('Nothing',TEMPLATE_DOMAIN).'</label>
				</td>
			</tr>
			<tr><td colspan="2"><h3>'.__('Custom menus :',TEMPLATE_DOMAIN).'</h3></td></tr>';
			$i=0;
			if (is_array($freshy_options['custom_menus'])) {
			foreach ($freshy_options['custom_menus'] as $custom_menu) {
				print '<tr>
					<th scope="row">
						<label>'.__('Custom menu entry',TEMPLATE_DOMAIN).' </label>
					</th>
					<td>
						<label>'.__('label',TEMPLATE_DOMAIN).' : '.$custom_menu['label'].' <i>('.__('url',TEMPLATE_DOMAIN).' : '.$custom_menu['url'].')</i></label> <input type="checkbox" name="custom_menu_'.$i.'"/> (delete)
					</td>
				</tr>';
				$i++;
			} }
			print '<tr>
				<th scope="row">
					<label>'.__('New custom menu entry',TEMPLATE_DOMAIN).' </label>
				</th>
				<td>
					<label>'.__('label',TEMPLATE_DOMAIN).' :</label> <input name="new_custom_menu_label" type="text" value=""/>
					<label>'.__('url',TEMPLATE_DOMAIN).' :</label> <input name="new_custom_menu_url" type="text" value=""/>
				</td>
			</tr>
			<tr><td colspan="2"><h3>'.__('Custom quicklinks :',TEMPLATE_DOMAIN).'</h3></td></tr>';
			$i=0;
			if (is_array($freshy_options['custom_quicklinks'])) {
			foreach ($freshy_options['custom_quicklinks'] as $custom_quicklink) {
				print '<tr>
					<th scope="row">
						<label>'.__('Custom quicklink entry',TEMPLATE_DOMAIN).' </label>
					</th>
					<td>
						<label>'.__('label',TEMPLATE_DOMAIN).' : '.$custom_quicklink['label'].' <i>('.__('url',TEMPLATE_DOMAIN).' : '.$custom_quicklink['url'].')</i></label> <input type="checkbox" name="custom_quicklink_'.$i.'"/> (delete)
					</td>
				</tr>';
				$i++;
			} }
			print '<tr>
				<th scope="row">
					<label>'.__('New custom quicklink entry',TEMPLATE_DOMAIN).' </label>
				</th>
				<td>
					<label>'.__('label',TEMPLATE_DOMAIN).' :</label> <input name="new_custom_quicklink_label" type="text" value=""/>
					<label>'.__('url',TEMPLATE_DOMAIN).' :</label> <input name="new_custom_quicklink_url" type="text" value=""/>
				</td>
			</tr>
		</table>
						
		<p class="submit"><input type="submit" name="Submit" value="'.__('Update Options &raquo;',TEMPLATE_DOMAIN).'"/></p>
		</form>
		</div>
		';
		/*
		print '
		<div id="preview" class="wrap">
		<h2 id="preview-post">'.__('Preview').' <small>('.__('updated when options are saved - attention : changes you make take effect immediately on the site !').')</small></h2>
		<iframe src="../?preview=true" width="100%" height="600" ></iframe>
		</div>
		';*/
	}
}

function freshy_list_files($dirpath,$filter='',$excludes='')
{
	$return_array=array();

	if (is_dir($dirpath))
	{
	   	if ($dh = opendir($dirpath))
	   	{
			while (false !== ($file = readdir($dh)))
			{
				if (!is_dir($dirpath.$file))
				{
					$exclude_file=false;
					if ($excludes!='')
					{
						foreach ($excludes as $exclude)
						{
							if ($exclude == $file)
							{
								$exclude_file=true;
								break;
							}
						}
					}
					if ($exclude_file!=true && $filter!='' && strstr($file, $filter) != false) $return_array[$file] = $file;
					else if ($exclude_file!=true && $filter=='') $return_array[$file] = $file;
				}
			}
		    closedir($dh);
		}
	}
	else $this->message = '<div class="error"><p>'.__('It seems that the directory','customize').' "'.$dirpath.'" '.__('does not exist','customize').'</p></div>';
    return $return_array;
}

function freshy_get_comment_excerpt() {
	global $comment;
	$comment_text = strip_tags($comment->comment_content);
	$blah = explode(' ', $comment_text);
	if (count($blah) > 10) {
		$k = 10;
	} else {
		$k = count($blah);
	}
	$excerpt = '';
	for ($i=0; $i<$k; $i++) {
		$excerpt .= $blah[$i] . ' ';
	}
	return apply_filters('get_comment_excerpt', $excerpt);
}

?>